/* Revision Control

$Header: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grpgtxt.cpp,v 1.2 2002-08-29 11:49:14+02 renz Exp $ 

$Id: grpgtxt.cpp,v 1.2 2002-08-29 11:49:14+02 renz Exp $ 

$Log: grpgtxt.cpp,v $
Revision 1.2  2002-08-29 11:49:14+02  renz
Added RCS Headers
 

$Author: renz $ 

$Date: 2002-08-29 11:49:14+02 $ 

$Locker:  $ 

$Revision: 1.2 $ 

$Name:  $ 

$RCSfile: grpgtxt.cpp,v $ 

$Source: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grpgtxt.cpp,v $ 

*/

#include "GrphclRp\GrphclOb\GRPgTxt.h"
#include "GrphclRp\GrphclOb\GRStaff.h"
#include "GrphclRp\GrphclOb\GRPage.h"
#include "GrphclRp\GrphclOb\grdefine.h"
#include "GrphclRp\GrphclOb\GRSpecil.h"
#include "GrphclRp\GrphclOb\GRVoice.h"
#include "nview.h"


GRPageText::GRPageText(
				ARMusicalTag *o,
				GRPage *p_grpage,
				 const NVstring * p_txt,
				 const NVstring * p_pageformat,
				 const NVstring * p_textformat,
				 const NVstring * p_textfont,
				 long p_textsize,
				 const NVstring * p_textattrib)
				 
  : GRTagARNotationElement(o)
{

	setTagType(GRTag::PAGETAG);

	grpage = p_grpage;

	if (p_txt)
		txt = *p_txt;
	if (p_pageformat)
		pageformat = *p_pageformat;
	if (p_textformat)
		textformat = *p_textformat;
	else
		textformat = "lt";

	if (p_textfont)
		font = new NVstring(*p_textfont);

	if (p_textattrib)
		fontAttrib = new NVstring(*p_textattrib);



	fontSize = p_textsize;

	// now, we have to get a font ...
	// this is plattform-dependant code ...
	// this was done in special?

	HFONT myfont = hfonttext;

	if (font && font->length()>0)
	{
		// here, size and attributes must be
		// regarded!!!!!
		myfont = GRSpecial::getFont(fontSize,
			font,
			fontAttrib);
	}


  // depending on the textformat ...
  int xdir = TA_LEFT;
  int ydir = TA_TOP;
  if (textformat.length()==2)
  {
	  if (textformat.get_at(0) == 'l')
		  xdir = TA_LEFT;
	  else if (textformat.get_at(0) == 'c')
		  xdir = TA_CENTER;
	  else if (textformat.get_at(0) == 'r')
		  xdir = TA_RIGHT;
	  
	  if (textformat.get_at(1) == 't')
		  ydir = TA_TOP;
	  else if (textformat.get_at(1) == 'c')
		  ydir = TA_BASELINE;
	  else if (textformat.get_at(1) == 'b')
		  ydir = TA_BOTTOM;
  }

    textalign = xdir | ydir;

	// Screen-DC
	HDC hdc = GetDC(NULL);
	HFONT hfontold = (HFONT) SelectObject(hdc,myfont);


	long width;
	long height;



	const char * cp = txt.c_str();
#ifndef __FLAT__
	width = LOWORD(GetTextExtent(hdc,cp,lstrlen(cp) ));
	height = HIWORD(GetTextExtent(hdc,cp,lstrlen(cp) ));
#else
	SIZE mysize;
	GetTextExtentPoint32(hdc,cp,lstrlen(cp),&mysize);
	width = mysize.cx;
	height = mysize.cy;
#endif

// 	boundingRectangle.bottom = 4*LSPACE;

	SelectObject(hdc,hfontold);
	ReleaseDC(NULL,hdc);

	// left and right Space is not
	// useful -> these are PageTexts

	if (xdir == TA_LEFT)
	{
		boundingRectangle.right = width;
		boundingRectangle.left = 0;
	}
	else if (xdir == TA_RIGHT)
	{
		boundingRectangle.left = -width;
		boundingRectangle.right = 0;
	}
	else if (xdir == TA_CENTER)
	{
		boundingRectangle.left = -width/2;
		boundingRectangle.right = width/2;
	}

	if (ydir == TA_TOP)
	{
		boundingRectangle.top = 0;
		boundingRectangle.bottom = height;
	}
	else if (ydir == TA_BASELINE)
	{
		boundingRectangle.top = -height;
		boundingRectangle.bottom = 2*LSPACE;
	}
	else if (ydir == TA_BOTTOM)
	{
		boundingRectangle.top = -height;
		boundingRectangle.bottom = 0;
	}
}


GRPageText::~GRPageText()
{
}



void GRPageText::OnDraw(HDC hdc) const
{

	GRTagARNotationElement::OnDrawText(hdc,txt.c_str());

  /* const char *cp = txt.c_str();
  HFONT hmyfont = hfonttext;
  
  if (textfont.length() > 0)
  {
	  // handle font-attributes ...
	  hmyfont = GRSpecial::getFont(textsize,&textfont,
		  &textattrib);
  }
  HFONT hfontold = (HFONT) SelectObject(hdc,hmyfont);
  int nBackmode = GetBkMode(hdc);
  UINT ta = GetTextAlign(hdc);
  SetBkMode(hdc,TRANSPARENT);

	
  if (colref)
	SetTextColor(hdc,RGB(colref[0],colref[1],colref[2]));
  
  // depending on the textformat ...
  int xdir = TA_LEFT;
  int ydir = TA_TOP;
  if (textformat.length()==2)
  {
	  if (textformat.get_at(0) == 'l')
		  xdir = TA_LEFT;
	  else if (textformat.get_at(0) == 'c')
		  xdir = TA_CENTER;
	  else if (textformat.get_at(0) == 'r')
		  xdir = TA_RIGHT;
	  
	  if (textformat.get_at(1) == 't')
		  ydir = TA_TOP;
	  else if (textformat.get_at(1) == 'c')
		  ydir = TA_BASELINE;
	  else if (textformat.get_at(1) == 'b')
		  ydir = TA_BOTTOM;
  }

  SetTextAlign(hdc,xdir | ydir);
  TextOut(hdc,position.x,
	  position.y,
	  	cp,lstrlen(cp));
  SetTextAlign(hdc,ta);
  SetBkMode(hdc,nBackmode);
  SelectObject(hdc,hfontold);
 
  if (colref)
	SetTextColor(hdc,RGB(0,0,0));
*/
}


void GRPageText::print() const
{
}


// this routine calculates the position of
// the text using the grpage and the format
// tag ...
void GRPageText::calcPosition()
{

	if (!grpage) return;


	// now we have the grpage and we have the
	// Format string.

	if (pageformat.length() != 2) return;
	char first = pageformat.get_at(0);
	char second = pageformat.get_at(1);

	float ml;
	float mt;
	float mr;
	float mb;

	grpage->getMargins(&ml,&mt,&mr,&mb);

	if (first == 'l' || first == '1')
		position.x = 0;
	else if (first == '2')
		position.x = (ml / UNCONST) / 2;
	else if (first == '3')
		position.x = ml / UNCONST;
	else if (first == 'c' || first == '4')
		position.x = grpage->getSizeX()/2;
	else if (first == '5')
		position.x = grpage->getSizeX() -
				(mr / UNCONST);
	else if (first == '6')
		position.x = grpage->getSizeX() -
			((mr / UNCONST) / 2);
	else if (first == 'r' || first == '7')
		position.x = grpage->getSizeX();

	if (second == 't' || second == '1')
		position.y = 0;
	else if (second == '2')
		position.y = (mt / UNCONST) / 2;
	else if (second == '3')
		position.y = (mt / UNCONST);
	else if (second == 'c' || second == '4')
		position.y = grpage->getSizeY()/2;
	else if (second == '5')
		position.y = grpage->getSizeY() -
				(mb / UNCONST);
	else if (second == '6')
		position.y = grpage->getSizeY() -
				((mb / UNCONST) / 2);
	else if (second == 'b' || second == '7')
		position.y = grpage->getSizeY();


}


